<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function sub_categories()
    {
        return $this->hasMany('SubCategory');
    }

    public function user_tracking()
    {
        return $this->hasMany('UserTracking');
    }

}